//
// Master Include File for Player A: Helmet and Face
//
#include "playerA.inc"

#ifndef (playerDamaged)
  #declare playerDamaged = 0
#end

// Dull creates a large, soft highlight on the object's surface
#declare myDull = finish {ambient 0.2 specular 0.25 roughness 0.40}
#declare boneTexture = texture {
  pigment {color bodyColor}
  finish {myDull}
}


#if (playerDamaged = 0)
  #include "XBlast Skeleton.inc"
#else
  #include "XBlast Skeleton.inc"
#end

#ifndef (playerWalkHeight)
  #declare playerWalkHeight = 0.0
#end

#declare Player = 
union {
  object {PlayerHead     translate < 0.00, 3.25, 0.00> }
  object {PlayerBody     translate < 0.00, 1.90, 0.00> }
  object {PlayerLeftArm  translate < 0.70, 2.35, 0.00> }
  object {PlayerRightArm translate <-0.70, 2.35, 0.00> }
  object {PlayerRightLeg translate <-0.40, 1.20, 0.00> }
  object {PlayerLeftLeg  translate < 0.40, 1.20, 0.00> }
  translate <0.0, -1.20, 0.0>
  rotate bodyAngle
  translate <0.0,  1.20, 0.0>
  translate y*playerWalkHeight
}





